<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="{{ url('public/images/logo.png')}}" type="image/x-icon">
    <!-- external css  -->
    <link rel="stylesheet" href="{{ url('public/css/style.css')}}">
     <!-- Boxicons CSS -->
    <link href='https://cdn.boxicons.com/fonts/basic/boxicons.min.css' rel='stylesheet'>
    <link href='https://cdn.boxicons.com/fonts/brands/boxicons-brands.min.css' rel='stylesheet'>
    <!-- embla carousel css -->
    <link rel="stylesheet" href="https://unpkg.com/embla-carousel/embla-carousel.min.css">

    <title>Digital Gross Hub - Home</title>
</head>
<body>
    <nav>
        <div>
            <img src="{{ url('public/images/logo-2.png')}}" alt="Logo" class="logo">
        </div>
        <ul class="nav-links">
            <li><a href="index.html">Home</a></li>
            <li><a href="#about">About</a></li>
            <li><a href="#financial-services">Financial Services</a></li>
            <li><a href="#reviews">Review</a></li>
            <li><a href="mailto:info@vaults">Contact</a></li>
            <a href="{{route('login')}}">
                <button class="login-btn">Login</button>
            </a>
            <a href="{{route('register')}}">
                <button class="signup-btn">Sign Up</button>
            </a>
        </ul>
    </nav>
    <!-- hero section  -->
    <!-- hero section and embla carousel and embla__slide background image -->
    <section class="hero embla">
        <div class="embla__container hero-content">
            <div class="embla__slide hero-slide" style="background-image: url('public/images/digital-strategy.jpg'); background-size: cover;">
                <div class="hero-text">
                    <h1>Welcome to Our Website</h1>
                    <p>Your success starts here. Join us today!</p>
                    <a href="{{route('register')}}">
                    <button class="get-started-btn">Get Started</button>
                    </a>
                </div>
            </div>
            <div class="embla__slide hero-slide" style="background-image:  url('public/images/marketing-computer-sign-symbol-concept-scaled-1.jpg'); background-size: cover;">
                <div class="hero-text">    
                    <h1>Discover Our Services</h1>
                    <p>We offer a wide range of services to meet your needs.</p>
                  <a href="{{route('register')}}">
                    <button class="get-started-btn">Explore Now</button>
                    </a>
                </div>
            </div>
            <div class="embla__slide hero-slide" style="background-image: url('public/images/workaholics-businesspeople-brainstorming-financial-company-ideas-analyzing-strategy-paperwork-late-night-business-office-meeting-room-scaled-1.jpg'); background-size: cover;">
                <div class="hero-text"> 
                    <h1>Join Our Community</h1>
                    <p>Connect with like-minded individuals and grow together.</p> <a href="{{route('register')}}">
                    <button class="get-started-btn">Get Started</button>
                    </a>
                     <a href="{{route('register')}}">
                    <button class="get-started-btn">Join Us</button>
                    </a>
                </div>
            </div>
        </div>
    </section>
    
    <section class="two-column container" id="about">
        <div class="text-content">
            <h2>About Digital Gross Hub</h2>
            <p>
                Partnering with Digital Gross Hub is a win-win. we get more business; you get more cash.
                We are a team of experienced marketers, content creators, and technology enthusiasts who 
                believe in the power of affiliate marketing to create mutually beneficial partnerships 
                between brands and publishers. With years of combined experience in digital marketing, 
                we've honed our skills to provide effective solutions that drive results for both our 
                partners and our audience.
            </p>
            <p>
                Our dedicated team leverages the depth and breadth of Digital Gross Hub 
                to deliver investment solutions that are aligned with asset management 
                priorities. From preserving wealth to maintaining cash flow 
                to outperforming public markets, our clients use our full spectrum of 
                public and private markets strategies to help secure their financial 
                futures.
            </p>
            <button class="learn-more-btn">Learn More</button>
        </div>
        <div class="image-content">
            <img src="{{ url('public/images/workaholics-businesspeople-brainstorming-financial-company-ideas-analyzing-strategy-paperwork-late-night-business-office-meeting-room-scaled-1.jpg')}}" alt="About Image" class="about-image">
        </div>
    </section>

    <!-- financial services -->
    <section class="financial-services" id="financial-services">
        <h2>Our Financial Services</h2>
        <div class="services-container">
            <div class="service-card">
                <i class='bx  bx-coin' ></i> 
                <h3>Investment Planning</h3>
                <p>We provide comprehensive investment planning services to help you achieve your financial goals.</p>
            </div>
            <div class="service-card">
                <i class='bx  bx-sapling'  ></i> 
                <h3>Retirement Solutions</h3>
                <p>Our retirement solutions are designed to ensure a secure and comfortable future for you and your family.</p>
            </div>
            <div class="service-card">
                <i class='bx  bx-wallet' ></i>
                <h3>Wealth Management</h3>
                <p>We offer personalized wealth management services to help you grow and protect your assets.</p>
            </div>
        </div>
    </section>

    <!-- why us? -->
    <section class="why-choose-us">
        <h2>Why Choose Us?</h2>
        <div class="features-container container">
            <div class="reasons-container">
                <div class="reason-card">
                    <i class='bx  bx-shield'  ></i> 
                    <h3>Trusted Expertise</h3>
                    <p>Our team of experts has years of experience in the financial industry, ensuring you receive the best advice and service.</p>
                </div>
                <div class="reason-card">
                    <i class='bx  bx-clock-2'  ></i> 
                    <h3>Timely Support</h3>
                    <p>We are committed to providing timely support and assistance to our clients whenever they need it.</p>
                </div>
                <div class="reason-card">
                    <i class='bx  bx-globe' ></i>
                    <h3>Global Reach</h3>
                    <p>With a global network, we can offer our clients access to international markets and opportunities.</p>
                </div>
            </div>
            <div class="why-us-image">
                <img src="{{ url('public/images/marketing-computer-sign-symbol-concept-scaled-1.jpg')}}" alt="Why Us Image" class="why-image">
            </div>
        </div>
    </section>

    <!-- What Users Say About Us with embla caurousel -->
    <section class="testimonials" id="reviews">
        <h2>What Users Say About Us</h2>
        <div class="testimonial-cards container">
            <div class="testimonial-card">
                <img src="https://images.unsplash.com/photo-1701615004837-40d8573b6652?ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxzZWFyY2h8MTR8fGF2YXRhcnxlbnwwfHwwfHx8Mg%3D%3D&auto=format&fit=crop&q=60&w=600" alt="">
                <p>"Digital Gross Hub has transformed the way I approach affiliate marketing. Their platform is user-friendly and the support team is fantastic!"</p>
                <h3>- Sarah L.</h3>
            </div>
            <div class="testimonial-card">
                <img src="https://images.unsplash.com/photo-1636041246191-7a73c36ccbe7?ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxzZWFyY2h8MTU1fHxhdmF0YXJ8ZW58MHx8MHx8fDA%3D&auto=format&fit=crop&q=60&w=600" alt="">
                <p>"Thanks to Digital Gross Hub, I've been able to significantly increase my online income. The variety of offers available is impressive."</p>
                <h3>- Mark D.</h3>
            </div>
            <div class="testimonial-card">
                <img src="https://images.unsplash.com/photo-1607746882042-944635dfe10e?ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxzZWFyY2h8MTN8fGF2YXRhcnxlbnwwfHwwfHx8Mg%3D%3D&auto=format&fit=crop&q=60&w=600" alt="">
                <p>"I highly recommend Digital Gross Hub to anyone looking to get into affiliate marketing. Their resources and tools are top-notch."</p>
                <h3>- Emily R.</h3>
            </div>
        </div>
    </section>
    
    <!-- standard footer section -->
    <footer>
        <div class="footer-container container">
            <div class="footer-about">
                <h3>About Digital Gross Hub</h3>
                <img src="{{ url('public/images/logo-2.png')}}" alt="">
                <p>Digital Gross Hub is a leading affiliate marketing platform that connects publishers with top brands to create successful partnerships.</p>
            </div>
            <div class="footer-links">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="index.html">Home</a></li>
                    <li><a href="#about">About</a></li>
                    <li><a href="#financial-services">Financial Services</a></li>
                    <li><a href="#reviews">Review</a></li>
                    <li><a href="mailto:info@vaults">Contact</a></li>
                </ul>
            </div>
            <div class="footer-contact">
                <h3>Contact Us</h3>
                <p>Email:info@vaults.com</p>
                <p>Phone: +123 456 7890</p>
                <p>Address: 123 Main St, Anytown, USA</p>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; 2024 Digital Gross Hub. All rights reserved.</p>
        </div>
    </footer>

    <!-- Floating Chat Button -->
    <!--<button class="chat-btn" id="openChatBtn">💬</button>-->

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> 
    <script src="{{ url('public/js/script.js')}}"></script>
    <script src="https://unpkg.com/embla-carousel/embla-carousel.umd.js"></script>
    <script src="https://unpkg.com/embla-carousel-autoplay/embla-carousel-autoplay.umd.js"></script>
    
    
    <script type="text/javascript">
        const emblaNode = document.querySelector('.embla')
        const options = { loop: true }
        const plugins = [EmblaCarouselAutoplay()]
        const emblaApi = EmblaCarousel(emblaNode, options, plugins)
    
        // Wait for JivoChat to load, then hook custom button
        document.addEventListener("DOMContentLoaded", () => {
            const chatBtn = document.getElementById("openChatBtn");

            chatBtn.addEventListener("click", () => {
                if (typeof jivo_api !== "undefined") {
                jivo_api.open();
                } else {
                alert("Chat is still loading. Please try again in a moment.");
                }
            });
        });

        // smooth page scroll
        $(document).ready(function(){
            $('a[href^="#"]').on('click', function(event) {
                var target = $(this.getAttribute('href'));
                if( target.length ) {
                    event.preventDefault();
                    $('html, body').stop().animate({
                        scrollTop: target.offset().top
                    }, 1000);
                }
            });
        });
    </script>
    





<!--<script src="//code.tidio.co/xx519a6mskge9yy9dc7wkwuh7wdcsu2q.js" async></script>-->


<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/671043dd4304e3196ad2f99f/1iaboi73s';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->
</body>
</html>

