<?php $__env->startSection('title'); ?>
    <?php echo e(__('Login')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Login Section -->

    <section class="section-style site-auth grad-overlay"
             style="background: url(<?php echo e(asset('frontend/theme_base/money_invest/materials/banners/auth-banner.jpg')); ?>) no-repeat center center; background-size: cover;">
        <div class="container">
            <div class="row justify-content-end">
                <div class="col-xl-5 col-lg-8 col-md-12">
                    <div class="auth-content">
                        <div class="logo">
                            <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt=""/></a>
                        </div>
                        <div class="title">
                            <h2> <?php echo e($data['title']); ?></h2>
                            <p><?php echo e($data['bottom_text']); ?></p>
                        </div>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <strong><?php echo e($error); ?></strong>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                            </div>
                        <?php endif; ?>


                        <div class="site-auth-form">
                            <form method="POST" action="<?php echo e(route('login')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="single-field">
                                    <label class="box-label" for="email"><?php echo e(__('Email Or Username')); ?></label>
                                    <input
                                        class="box-input"
                                        type="text"
                                        name="email"
                                        required
                                    />
                                </div>
                                <div class="single-field">
                                    <label class="box-label" for="password"><?php echo e(__('Password')); ?></label>
                                    <div class="password">
                                        <input
                                            class="box-input"
                                            type="password"
                                            name="password"
                                            required
                                        />
                                    </div>
                                </div>

                                <?php if($googleReCaptcha): ?>
                                    <div class="g-recaptcha mb-3" id="feedback-recaptcha"
                                         data-sitekey="<?php echo e(json_decode($googleReCaptcha->data,true)['google_recaptcha_key']); ?>">
                                    </div>
                                <?php endif; ?>

                                <div class="single-field">
                                    <input
                                        class="form-check-input check-input"
                                        type="checkbox"
                                        name="remember"
                                        id="flexCheckDefault"
                                    />
                                    <label class="form-check-label" for="flexCheckDefault">
                                        <?php echo e(__('Remember me')); ?>

                                    </label>

                                    <?php if(Route::has('password.request')): ?>
                                        <span class="forget-pass-text"><a
                                                href="<?php echo e(route('password.request')); ?>"><?php echo e(__('Forget Password')); ?></a></span>
                                    <?php endif; ?>
                                </div>
                                <button type="submit" class="site-btn grad-btn w-100">
                                    <?php echo e(__('Account Login')); ?>

                                </button>
                            </form>
                            <div class="singnup-text">
                                <p>
                                    <?php echo e(__("Don't have an account?")); ?>

                                    <a href="<?php echo e(route('register')); ?>"><?php echo e(__('Signup for free')); ?></a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Login Section End -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php if($googleReCaptcha): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/notionin/public_html/digitalgrosshub.com/app/Providers/../../resources/views/frontend/money_invest/auth/login.blade.php ENDPATH**/ ?>