<?php
    $schemas = \App\Models\Schema::where('status',true)->with('schedule')->get();
?>
<section class="white-bg section-style-2">
    <div class="bat-left" style="background: url(<?php echo e(asset($data['left_top_img'])); ?>) repeat;" data-aos="fade-down-right"
         data-aos-duration="2000"></div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-7 col-lg-12">
                <div class="section-title text-center">
                    <h4 data-aos="fade-down" data-aos-duration="2000"><?php echo e($data['title_small']); ?></h4>
                    <h2 data-aos="fade-down" data-aos-duration="1500"><?php echo e($data['title_big']); ?></h2>
                </div>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $schemas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schema): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-lg-6 col-md-6 col-12">
                    <div class="single-investment-plan">
                        <img
                            class="investment-plan-icon"
                            src="<?php echo e(asset($schema->icon)); ?>"
                            alt=""
                        />
                        <?php if($schema->badge): ?>
                            <div class="feature-plan"><?php echo e($schema->badge); ?></div>
                        <?php endif; ?>

                        <h3><?php echo e($schema->name); ?></h3>
                        <p><?php echo e($schema->schedule->name . ' '. ($schema->interest_type == 'percentage' ? $schema->return_interest.'%' : $currencySymbol.$schema->return_interest )); ?></p>
                        <ul> 
                            <li><?php echo e(__('Investment')); ?> <span class="special">
                                                                <?php echo e($schema->type == 'range' ? $currencySymbol . $schema->min_amount . '-' . $currencySymbol . $schema->max_amount : $currencySymbol . $schema->fixed_amount); ?>

                                                            </span></li>
                            <li><?php echo e(__('Capital Back')); ?> <span><?php echo e($schema->capital_back ? __('Yes') : __('No')); ?></span>
                            </li>
                            <li><?php echo e(__('Return Type')); ?> <span><?php echo e(__(ucwords($schema->return_type))); ?></span></li>
                            <li><?php echo e(__('Number of Period')); ?>

                                <span><?php echo e(($schema->return_type == 'period' ? $schema->number_of_period.' ' : __('Unlimited').' ' ).($schema->number_of_period == 1 ? __('Time') : __('Times') )); ?></span>
                            </li>
                            <li><?php echo e(__('Profit Withdraw')); ?> <span><?php echo e(__('Anytime')); ?></span></li>
                            <li><?php echo e(__('Cancel')); ?> <span> <?php if($schema->schema_cancel): ?>
                                        <?php echo e(__('Within').' '. $schema->expiry_minute .' '. 'Minute'); ?>

                                    <?php else: ?>
                                        <?php echo e(__('No')); ?>

                                    <?php endif; ?></span></li>
                        </ul>
                        <div class="holidays"><span class="star">*</span><?php if( null != $schema->off_days): ?>
                                <?php echo e(implode(', ', json_decode($schema->off_days,true))  .' '.__('are')); ?>

                            <?php else: ?>
                                <?php echo e(__('No Profit')); ?>

                            <?php endif; ?> <?php echo e(__('Holidays')); ?></div>
                        <a href="<?php echo e(route('user.schema.preview',$schema->id)); ?>" class="site-btn grad-btn w-100 centered"><i
                                class="anticon anticon-check"></i><?php echo e(__('Invest Now')); ?></a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/notionin/public_html/digitalgrosshub.com/app/Providers/../../resources/views/frontend/default/home/include/__schema.blade.php ENDPATH**/ ?>